/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.handler;

import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.IExoflameHeatable;
import vazkii.botania.mixin.AccessorAbstractFurnaceBlockEntity;
import vazkii.botania.xplat.IXplatAbstractions;

public class ExoflameFurnaceHandler {
    public static boolean canSmelt(AbstractFurnaceBlockEntity furnace, Recipe<?> recipe) {
        NonNullList<ItemStack> items = ((AccessorAbstractFurnaceBlockEntity)furnace).getItems();
        return IXplatAbstractions.INSTANCE.canFurnaceBurn(furnace, recipe, items, furnace.m_6893_());
    }

    public static RecipeType<? extends AbstractCookingRecipe> getRecipeType(AbstractFurnaceBlockEntity furnace) {
        return ((AccessorAbstractFurnaceBlockEntity)furnace).getRecipeType();
    }

    public static class FurnaceExoflameHeatable
    implements IExoflameHeatable {
        private final AbstractFurnaceBlockEntity furnace;
        private RecipeType<? extends AbstractCookingRecipe> recipeType;
        private AbstractCookingRecipe currentRecipe;

        public FurnaceExoflameHeatable(AbstractFurnaceBlockEntity furnace) {
            this.furnace = furnace;
        }

        @Override
        public boolean canSmelt() {
            if (this.furnace.m_8020_(0).m_41619_()) {
                return false;
            }
            try {
                if (this.recipeType == null) {
                    this.recipeType = ExoflameFurnaceHandler.getRecipeType(this.furnace);
                }
                if (this.currentRecipe != null && this.currentRecipe.m_5818_((Container)this.furnace, this.furnace.m_58904_()) && ExoflameFurnaceHandler.canSmelt(this.furnace, this.currentRecipe)) {
                    return true;
                }
                this.currentRecipe = this.furnace.m_58904_().m_7465_().m_44015_(this.recipeType, (Container)this.furnace, this.furnace.m_58904_()).orElse(null);
                return ExoflameFurnaceHandler.canSmelt(this.furnace, this.currentRecipe);
            }
            catch (Throwable t) {
                BotaniaAPI.LOGGER.error("Failed to determine if furnace TE can smelt", t);
                return false;
            }
        }

        @Override
        public int getBurnTime() {
            return ((AccessorAbstractFurnaceBlockEntity)this.furnace).getLitTime();
        }

        @Override
        public void boostBurnTime() {
            if (this.getBurnTime() == 0) {
                Level world = this.furnace.m_58904_();
                BlockPos pos = this.furnace.m_58899_();
                world.m_46597_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)));
            }
            int burnTime = ((AccessorAbstractFurnaceBlockEntity)this.furnace).getLitTime();
            ((AccessorAbstractFurnaceBlockEntity)this.furnace).setLitTime(burnTime + 200);
        }

        @Override
        public void boostCookTime() {
            int cookTime = ((AccessorAbstractFurnaceBlockEntity)this.furnace).getCookingProgress();
            int cookTimeTotal = ((AccessorAbstractFurnaceBlockEntity)this.furnace).getCookingTotalTime();
            ((AccessorAbstractFurnaceBlockEntity)this.furnace).setCookingProgress(Math.min(cookTimeTotal - 1, cookTime + 1));
        }
    }
}

